import sys
sys.setrecursionlimit(1 << 25)

def main():
    n = int(sys.stdin.readline())
    nums = sys.stdin.readline().split()

    children = []
    parent = []
    terminal_id = []
    parent_digit = []

    def new_node(p=-1, pd=None):
        children.append({})
        parent.append(p)
        parent_digit.append(pd)
        terminal_id.append(-1)
        return len(children) - 1

    root = new_node()
    node_of = [None] * n

    for i, s in enumerate(nums):
        v = root
        for ch in s:
            if ch not in children[v]:
                nxt = new_node(v, ch)
                children[v][ch] = nxt
            v = children[v][ch]
        terminal_id[v] = i
        node_of[i] = v

    m = len(children)
    has_terminal_sub = [False] * m
    order = []
    stack = [root]
    while stack:
        v = stack.pop()
        order.append(v)
        for to in children[v].values():
            stack.append(to)
    for v in reversed(order):
        if terminal_id[v] != -1:
            has_terminal_sub[v] = True
        for to in children[v].values():
            if has_terminal_sub[to]:
                has_terminal_sub[v] = True

    leaf_term_nodes = []
    for v in range(m):
        if terminal_id[v] != -1:
            term_child = False
            for to in children[v].values():
                if has_terminal_sub[to]:
                    term_child = True
                    break
            if not term_child:
                leaf_term_nodes.append(v)

    assigned = [False] * n
    groups = []

    for leaf in leaf_term_nodes:
        g = []
        v = leaf
        while v != -1:
            tid = terminal_id[v]
            if tid != -1 and not assigned[tid]:
                assigned[tid] = True
                g.append(tid)
            v = parent[v]
        groups.append(g)

    for i in range(n):
        if not assigned[i]:
            groups.append([i])

    print(len(groups))
    for g in groups:
        print(len(g))
        print(" ".join(nums[i] for i in g))

if __name__ == "__main__":
    main()
